﻿using System;
using System.Configuration;
using System.IO;
using System.Net;
using NUnit.Framework;
using Spring.Context.Support;
using gov.va.med.VBECS.Communication.Server;
using gov.va.med.vbecs.Common.AppServices;
using gov.va.med.vbecs.Common.DependencyInjection;

namespace gov.va.med.vbecs.UnitTest.Communication
{
    [TestFixture]
    public class Server
    {
        private static void initialize()
        {
            //Two configuration files are necessary since object in first file should be created and ready for object in the second one.
            var common = @"file://" + Path.Combine(Environment.CurrentDirectory ?? ".", ConfigurationManager.AppSettings.Get("SpringConfigFileCommon"));
            var spring = @"file://" + Path.Combine(Environment.CurrentDirectory ?? ".", ConfigurationManager.AppSettings.Get("SpringConfigFile"));
            DiContext.AppContext = new XmlApplicationContext(new[] { common, spring });
        }


        // Inner TCP/IP server
        private IServer _server;

        [SetUp]
        protected void SetUp()
        {
            initialize();

            var portNumber =
                (int) GlobalContext.Instance().AppSettingsReader.GetValue("ListenerPortNumber", typeof (int));
            _server = ServerFactory.CreateServer(new IPEndPoint(IPAddress.Any, portNumber));
        }

        [Test]
        public void Start_Pass()
        {
            _server.Start();
        }

        [TearDown]
        protected void TearDown()
        {
            _server.Stop();
        }

    }
}
